DECLARE FUNCTION bn$ (a AS INTEGER)
DECLARE SUB kopie ()
DECLARE SUB avrtyp ()
DECLARE FUNCTION hx$ (wert AS INTEGER)
DECLARE FUNCTION hx4$ (wert AS LONG)
DECLARE SUB leertest ()
DECLARE SUB info ()
DECLARE FUNCTION dec! (s AS STRING)
DECLARE SUB stopavr ()
DECLARE SUB msgbox ()
DECLARE SUB setavrtyp ()
DECLARE SUB saveflash ()
DECLARE SUB saveeeprom ()
DECLARE SUB wrlock ()
DECLARE SUB compflash ()
DECLARE SUB compeeprom ()
DECLARE SUB brenncheck ()
DECLARE SUB taste ()
DECLARE SUB liesdir ()
DECLARE SUB lade ()
DECLARE SUB rdFlash ()
DECLARE SUB wrFlash ()
DECLARE SUB rdEeprom ()
DECLARE SUB wrEeprom ()
DECLARE SUB menue ()
DECLARE SUB ende ()
DECLARE SUB loesch ()
DECLARE SUB warte (n AS INTEGER, m AS INTEGER)
DECLARE SUB LiesSignatur ()
DECLARE SUB startavr ()
DECLARE SUB schreib ()

DIM SHARED aus(3) AS INTEGER            'Programmierbefehl
DIM SHARED ein(3) AS INTEGER            'Rcklese-Doppelwort
DIM SHARED p      AS INTEGER            'Portadresse
DIM SHARED pwr    AS INTEGER            'Bitnummer Power off
DIM SHARED rst    AS INTEGER            'Bitnummer Reset
DIM SHARED mosi   AS INTEGER            'Bitnummer MOSI
DIM SHARED sck    AS INTEGER            'Bitnummer SCK-Takt
DIM SHARED trb    AS INTEGER            'Bitnummer Treiberaktivierung (LS245)
DIM SHARED send   AS INTEGER            'Bitmuster fr Ausgabe
DIM SHARED sig1   AS INTEGER            'Chip-Code
DIM SHARED sig2   AS INTEGER            'Chip-Code
DIM SHARED sig3   AS INTEGER            'Chip-Code
DIM SHARED dir(99) AS STRING            'Dateiliste
DIM SHARED maxdir AS INTEGER            'Anzahl Dateien
DIM SHARED mp     AS INTEGER            'Menpunkt
DIM SHARED n$                           'Nullstring
DIM SHARED typ(16) AS STRING * 3        'Dateinamenerweiterung
DIM SHARED dana   AS STRING             'Dateiname
DIM SHARED danaf  AS STRING             'Dateiname Flash
DIM SHARED danae  AS STRING             'Dateiname EEPROM
DIM SHARED ff     AS LONG               'Anzahl falsche AVR-Antwort
DIM SHARED bv     AS LONG               'Anzahl Brennversuche
DIM SHARED eew(4096) AS INTEGER         'Datenfeld zum Schreiben in EEPROM
DIM SHARED eer(4096) AS INTEGER         'Datenfeld zum Lesen aus EEPROM
DIM SHARED wrm    AS LONG               'max benutzte Adresse in wr
DIM SHARED rdm    AS LONG               'max benutzte Adresse in rd
DIM SHARED ewm    AS INTEGER            'max benutzte Adresse in eew
DIM SHARED erm    AS INTEGER            'max benutzte Adresse in eer
DIM SHARED avrt   AS STRING             'Controllertyp
DIM SHARED abbr   AS INTEGER            'Abbruch-Flag
DIM SHARED msg1   AS STRING             'Ausgabetext 1
DIM SHARED msg2   AS STRING             'Ausgabetext 2
DIM SHARED msg3   AS STRING             'Ausgabetext 3
DIM SHARED msg4   AS STRING             'Ausgabetext 4
DIM SHARED angemeldet AS INTEGER        'Chip aktiviert?
DIM SHARED ta$                          'Rckgabe-Taste MSGBOX
DIM SHARED zt     AS DOUBLE             'Timer-Endwert
DIM SHARED gesperrt(18) AS INTEGER      'Menpunkt gesperrt
DIM SHARED leertst AS INTEGER           'Flag fr Leertest
DIM SHARED benutzt AS LONG              'Anzahl benutzter Flash-Zellen
DIM SHARED kalib AS INTEGER             'Kalibrations-Modus
DIM SHARED kalibyte(3) AS INTEGER       'Kalibrationsbyte (Wert)
DIM SHARED kalitext AS STRING           'Text fr Menbildschirm zu kalibra..
DIM SHARED delanz AS INTEGER            'Anzahl der Lschungen
DIM SHARED brenndauer AS SINGLE         'Zeitdauer des Brennens
DIM SHARED ugl AS LONG                  'Unterschiede beim Lesen
DIM SHARED clock AS INTEGER             'Taktfrequenz in Kalib 3.x
DIM SHARED fuseh AS INTEGER             'Fusebits H
DIM SHARED fusel AS INTEGER             'Fusebits L
DIM SHARED lockb AS INTEGER             'Lockbits
DIM SHARED fuseh1 AS INTEGER            'Siko Fusebits H
DIM SHARED fusel1 AS INTEGER            'Siko Fusebits L
DIM SHARED lockb1 AS INTEGER            'Siko Lockbits
DIM SHARED atkz AS INTEGER              'AVR-Typkennzahl
DIM SHARED kopierflag AS INTEGER        'Flag, dass kopiert werden soll

CLS
n$ = CHR$(0)
kalibyte(0) = 255
kalibyte(1) = 255
kalibyte(2) = 255
kalibyte(3) = 255
gesperrt(5) = 1: gesperrt(7) = 1
gesperrt(11) = 1: gesperrt(12) = 1: mp = 9
p = 888: pwr = 8: rst = 16: mosi = 32: sck = 64: trb = 128
send = 255: wrm = -1: ewm = -1: rdm = 2 ^ 15 - 1: erm = 2 ^ 12 - 1
OUT p, send
CLOSE
FOR i = 0 TO 512
  eer(i) = 255
  eew(i) = 255
NEXT i
DO
'  CLS
  menue
LOOP

SUB avrtyp
  DIM t(255) AS STRING, e(255) AS INTEGER, k(255) AS INTEGER

  t(1) = "AT 90 S 1200 ": e(1) = 6
  t(3) = "AT Tiny 10   "
  t(4) = "AT Tiny 11   "
  t(5) = "AT Tiny 12   ": e(5) = 6: k(5) = 11
  t(6) = "AT Tiny 15   ": e(6) = 6: k(6) = 12
  t(7) = "AT Tiny 13   ": e(7) = 6: k(7) = 41
 
  t(33) = "AT 90 S 2313 ": e(33) = 7
  t(34) = "AT 90 S 2323 ": e(34) = 7
  t(35) = "AT 90 S 2343 ": e(35) = 7
  t(37) = "AT 90 S 2333 ": e(37) = 7
  t(38) = "AT Tiny 22   ": e(38) = 7
  t(39) = "AT Tiny 28   "
  t(41) = "AT Tiny 26   ": e(41) = 7: k(41) = 30
  t(42) = "AT Tiny 2313 ": e(42) = 7: k(42) = 42

  t(65) = "AT 90 S 4414 ": e(65) = 8
  t(66) = "AT 90 S 4434 ": e(66) = 8
  t(67) = "AT 90 S 4433 ": e(67) = 8

  t(97) = "AT 90 S 8515 ": e(97) = 9
  t(99) = "AT 90 S 8535 ": e(99) = 9
  t(100) = "AT 90 S 8534 ": e(100) = 9
  t(102) = "AT Mega 8515 ": e(102) = 9: k(102) = 30
  t(103) = "AT Mega 8    ": e(103) = 9: k(103) = 30
  t(104) = "AT Mega 8535 ": e(104) = 9: k(104) = 30

  t(129) = "AT Mega 161  ": e(129) = 9
  t(130) = "AT Mega 163  ": e(130) = 9: k(130) = 20
  t(131) = "AT Mega 16   ": e(131) = 9: k(131) = 30
  t(132) = "AT Mega 162  ": e(132) = 9: k(132) = 40
  t(133) = "AT Mega 169  ": e(133) = 9: k(133) = 40

  t(161) = "AT Mega 323  ": e(161) = 10: k(161) = 20
  t(162) = "AT Mega 32   ": e(162) = 10: k(162) = 30

  t(194) = "AT Mega 64   ": e(194) = 11: k(194) = 31

  t(225) = "AT Mega 103  ": e(225) = 12
  t(226) = "AT Mega 128  ": e(226) = 12: k(226) = 31

  atkz = 32 * (sig2 - 144) + (sig3 AND 31)
  rdm = 2 ^ (9 + sig2 - 144) - 1
  erm = 2 ^ e(atkz) - 1
  avrt = t(atkz)
  IF avrt = "" THEN avrt = "Typ unbekannt   "
  kalib = k(atkz)
END SUB

FUNCTION bn$ (a AS INTEGER)
  i1$ = ""
  FOR i = 7 TO 0 STEP -1
    i1$ = i1$ + LTRIM$(STR$((a AND 2 ^ i) / 2 ^ i))
  NEXT i
  bn$ = i1$
END FUNCTION

SUB brenncheck
'berprfung AVR-Zugriff auf Korrektheit
  IF ff = 0 THEN EXIT SUB
'  EXIT SUB
  COLOR 4, 7
    LOCATE 10, 23
    PRINT " Ŀ "
    FOR i = 11 TO 14
      LOCATE i, 23
    PRINT "                                "
    NEXT i
    LOCATE 15, 23
    PRINT "  "
    LOCATE 11, 26
    PRINT "Kommunikations-Error mit AVR"
    LOCATE 12, 26
    PRINT USING "Gesendete Kommandos:   #####"; bv
    LOCATE 13, 26
    PRINT USING "Fehlerhafte Antworten: #####"; ff
    LOCATE 14, 26
    PRINT USING "Korrekte Antworten:    #####"; bv - ff
    LOCATE 16, 20
  COLOR 7, 0
  taste
END SUB

SUB compeeprom
  ugl = 0
  em = ewm: IF em = 0 THEN em = erm
  FOR i = 0 TO em
    IF eer(i) <> eew(i) THEN ugl = ugl + 1
    IF eer(i) <> 255 THEN nle = nle + 1
  NEXT i
  eem = ewm: IF erm > eem THEN eem = erm
  DO
    COLOR 7, 0
    CLS
    PRINT " Ŀ"
    PRINT " Adr. Write Read                   E E P R O M"
    PRINT " Ĵ"
    FOR i = 0 TO 20
      IF (ofs + i) <= eem THEN
        COLOR 7, 0
        LOCATE 4 + i, 2
        PRINT "               ";
        c1 = 7
        IF i + ofs > ewm THEN c1 = 4
        COLOR c1, 0
        IF eer(i + ofs) <> eew(i + ofs) THEN COLOR 0, c1
        LOCATE 4 + i, 3: PRINT hx4$(ofs + i);
        LOCATE 4 + i, 10: PRINT hx$(eew(i + ofs));
        LOCATE 4 + i, 16: PRINT hx$(eer(i + ofs));
        COLOR 7, 0
      END IF
    NEXT i
    LOCATE 25, 1
    PRINT " ";
    COLOR 7, 0
    LOCATE 8, 40
    PRINT USING "Bytes:           ##### "; em + 1;
    LOCATE 10, 40
    PRINT USING "Unterschiede:    ##### "; ugl;
    LOCATE 12, 40
    PRINT USING "Nicht leer:      ##### "; nle;
    DO
      k$ = INKEY$
    LOOP WHILE k$ = k1$
    SELECT CASE k$
      CASE CHR$(13)
        EXIT DO
      CASE CHR$(27)
        EXIT SUB
      CASE n$ + "H"
        ofs = ofs - 1
      CASE n$ + "P"
        ofs = ofs + 1
      CASE n$ + "I"
        ofs = ofs - 16
      CASE n$ + "Q"
        ofs = ofs + 16
      CASE n$ + "G"
        ofs = 0
      CASE n$ + "O"
        ofs = eem - 20
    END SELECT
    IF ofs < 0 THEN ofs = 0
    IF ofs > eem - 20 THEN ofs = eem - 20
  LOOP UNTIL k$ = CHR$(13)
END SUB

SUB compflash
  DIM wl AS INTEGER, wh AS INTEGER, rl AS INTEGER, rh AS INTEGER, l AS LONG
  em = wrm: IF em = 0 THEN em = rdm
  ugl = 0
  CLOSE
  OPEN "fl.tmp" FOR RANDOM AS #1 LEN = 2
  OPEN "fh.tmp" FOR RANDOM AS #2 LEN = 2
  OPEN "rfl.tmp" FOR RANDOM AS #3 LEN = 2
  OPEN "rfh.tmp" FOR RANDOM AS #4 LEN = 2
  FOR i = 0 TO em
    GET #1, i + 1, wl
    GET #2, i + 1, wh
    GET #3, i + 1, rl
    GET #4, i + 1, rh
    IF (rl <> wl) OR (rh <> wh) THEN ugl = ugl + 1
    IF rl <> 255 OR rh <> 255 THEN nle = nle + 1
  NEXT i
  eem = wrm: IF rdm > eem THEN eem = rdm
  DO
    COLOR 7, 0
    CLS
    PRINT " Ŀ"
    PRINT " Adr. Wri LWri HRea LRea H       F L A S H"
    PRINT " Ĵ"
    FOR i = 0 TO 20
      IF (ofs + i) <= eem THEN
        LOCATE 4 + i, 2
        PRINT "                         ";
        c1 = 7
        IF ofs + i > wrm THEN c1 = 4
        COLOR c1, 0
        GET #1, i + 1 + ofs, wl
        GET #2, i + 1 + ofs, wh
        GET #3, i + 1 + ofs, rl
        GET #4, i + 1 + ofs, rh
        IF rl <> wl THEN COLOR 0, c1
        IF rh <> wh THEN COLOR 0, c1
        LOCATE 4 + i, 3: PRINT hx4(ofs + i);
        LOCATE 4 + i, 10: PRINT hx$(wl);
        LOCATE 4 + i, 16: PRINT hx$(wh);
        LOCATE 4 + i, 22: PRINT hx$(rl);
        LOCATE 4 + i, 28: PRINT hx$(rh);
        COLOR 7, 0
      END IF
    NEXT i
    COLOR 7, 0
    LOCATE 25, 1
    PRINT " ";
    LOCATE 8, 40
    PRINT USING "Worte:           ##### "; em + 1;
    LOCATE 10, 40
    PRINT USING "Unterschiede:    ##### "; ugl;
    LOCATE 12, 40
    PRINT USING "Nicht leer:      ##### "; nle;
    LOCATE 14, 40
    PRINT USING "Brenndauer:      #####.# s "; brenndauer;
    DO
      k$ = INKEY$
    LOOP WHILE k$ = k1$
    SELECT CASE k$
      CASE CHR$(13)
        EXIT DO
      CASE CHR$(27)
        EXIT SUB
      CASE n$ + "H"
        ofs = ofs - 1
      CASE n$ + "P"
        ofs = ofs + 1
      CASE n$ + "I"
        ofs = ofs - 16
      CASE n$ + "Q"
        ofs = ofs + 16
      CASE n$ + "G"
        ofs = 0
      CASE n$ + "O"
        ofs = eem - 20
      CASE " " TO "z"
        EXIT SUB
    END SELECT
    IF ofs < 0 THEN ofs = 0
    IF ofs > eem - 20 THEN ofs = eem - 20
  LOOP UNTIL k$ = CHR$(13)
END SUB

FUNCTION dec (s AS STRING)
  s1$ = LCASE$(LEFT$(s, 1))
  s2$ = LCASE$(RIGHT$(s, 1))
  SELECT CASE s1$
    CASE "0" TO "9"
      w1% = ASC(s1$) - 48
    CASE "a" TO "f"
      w1% = ASC(s1$) - 87
  END SELECT
  SELECT CASE s2$
    CASE "0" TO "9"
      w2% = ASC(s2$) - 48
    CASE "a" TO "f"
      w2% = ASC(s2$) - 87
  END SELECT
  dc% = w1% * 16 + w2%
  dec = dc%
END FUNCTION

SUB ende
'  send = 255
'  OUT p, send
  COLOR 7, 0
  CLOSE
  OPEN "x.tmp" FOR BINARY AS #1
  CLOSE
  KILL "*.tmp"
  CLS
  SYSTEM
END SUB

FUNCTION hx$ (wert AS INTEGER)
  t$ = RIGHT$("00" + HEX$(wert), 2)
  hx$ = t$ + "h"
END FUNCTION

FUNCTION hx4$ (wert AS LONG)
  t$ = RIGHT$("0000" + HEX$(wert), 4)
  hx4$ = t$ + "h"
END FUNCTION

SUB info
  CLS
  PRINT "Dieses Programm dient der ISP-Programmierung von AVR-Mikrocontrollern"
  PRINT "Alle Rechte liegen bei ...HanneS... (hannes.lux@gmx.de)."
  PRINT
  PRINT "Um dieses Programm betreiben zu knnen, wird ein spezielles ISP-Interface"
  PRINT "bentigt, das nicht mit dem Interface von anderen Programmen identisch ist."
  PRINT
  PRINT "Mittels eines Bustreibers HCT245 werden die Signale gebuffert."
  PRINT "Mittels einer Transistorschaltung wird die Stromversorgung des zu brennenden"
  PRINT "AVRs vom PC geschaltet. Dazu muss das Interface mit +5V versorgt werden."
  PRINT
  PRINT "Die Steuerung erfolgt per Parallelport LPT1 ber folgende Leitungen:"
  PRINT
  PRINT " LPT1-Pin   In/Out Funktion"
  PRINT "       5    Out    Steuerung Betriebsspannung, (L=Aus, H=Ein)"
  PRINT "       6    Out    Reset (ber Bustreiber)"
  PRINT "       7    Out    MOSI (ber Bustreiber)"
  PRINT "       8    Out    SCK (ber Bustreiber)"
  PRINT "       9    Out    Aktivierung Bustreiber, L-aktiv (Pin 19 HCT245)"
  PRINT "      10    In     MISO (ber Bustreiber, rckwrts)"
  PRINT "      20           GND (Masse)"
  PRINT
  PRINT
  taste
END SUB

SUB kopie
  SHELL "dir *.tmp >avr.dir"
  OPEN "avr.dir" FOR INPUT AS #1
    DO UNTIL EOF(1)
      LINE INPUT #1, t$
      IF INSTR(1, LCASE$(t$), "fl.tmp") THEN d = d + 1
      IF INSTR(1, LCASE$(t$), "fh.tmp") THEN d = d + 2
      IF INSTR(1, LCASE$(t$), "rfl.tmp") THEN d = d + 4
      IF INSTR(1, LCASE$(t$), "rfh.tmp") THEN d = d + 8
    LOOP
  CLOSE
  KILL "avr.dir"
  IF d = 15 THEN
    KILL "fl.tmp"
    NAME "rfl.tmp" AS "fl.tmp"
    KILL "fh.tmp"
    NAME "rfh.tmp" AS "fl.tmp"
    kopierflag = 1
  ELSE
    msg1 = "Fehler... Kopie nicht mglich..."
    msg2 = "": msg3 = "": msg4 = ""
    msgbox
  END IF
END SUB

SUB lade
  liesdir
  DO
    CLS
    FOR i = 0 TO 20
      IF (dirofs + i) <= maxdir THEN
        COLOR 7, 0
        IF (dirofs + i) = dirnum THEN COLOR 0, 7
        LOCATE 2 + i, 2
        PRINT dir(dirofs + i)
        COLOR 7, 0
      END IF
    NEXT i
    DO
      k$ = INKEY$
    LOOP WHILE k$ = k1$
    SELECT CASE k$
      CASE CHR$(13)
        EXIT DO
      CASE CHR$(27)
        EXIT SUB
      CASE n$ + "H"
        dirnum = dirnum - 1
        IF dirnum < 0 THEN dirnum = maxdir
      CASE n$ + "P"
        dirnum = dirnum + 1
        IF dirnum > maxdir THEN dirnum = 0
    END SELECT
  LOOP UNTIL k$ = CHR$(13)
  dana = RTRIM$(LEFT$(dir(dirnum), 8)) + "." + typ(mp)
  CLS
  IF dana = "" THEN EXIT SUB
  IF mp = 9 THEN
    danaf = dana
    CLOSE
    OPEN "fl.tmp" FOR RANDOM AS #2 LEN = 2
    OPEN "fh.tmp" FOR RANDOM AS #3 LEN = 2
    CLOSE
    KILL "fl.tmp"
    KILL "fh.tmp"
    OPEN danaf FOR INPUT AS #1
    OPEN "fl.tmp" FOR RANDOM AS #2 LEN = 2
    OPEN "fh.tmp" FOR RANDOM AS #3 LEN = 2
      pt% = 0
      LINE INPUT #1, z0$
      DO UNTIL EOF(1)
        LINE INPUT #1, z0$
        z$ = ""
        IF LEN(z0$) > 11 THEN z$ = MID$(z0$, 10, LEN(z0$) - 11)
        FOR i = 1 TO LEN(z$) STEP 4
          nl% = dec(MID$(z$, i, 2))
          nh% = dec(MID$(z$, i + 2, 2))
          pt% = pt% + 1
          PUT #2, pt%, nl%
          PUT #3, pt%, nh%
          PRINT "    Lese FLASH von Datentrger... ";
          PRINT USING " ######"; pt%; nl%; nh%
        NEXT i
      LOOP
    CLOSE
    wrm = pt% - 1
    IF wrm > rdm THEN
      msg1 = "Eingelesene Datei ist"
      msg2 = "zu gro fr den Chip"
      msg3 = "Erlaubt sind:" + STR$(rdm) + " Worte"
      msg4 = "Tatschlich :" + STR$(wrm) + " Worte"
      msgbox
    END IF
    gesperrt(4) = 0: gesperrt(5) = 0: mp = 5
    'compflash
  ELSEIF mp = 10 THEN
    danae = dana
    CLOSE #1
    OPEN danae FOR INPUT AS #1
      pt% = 0
'      LINE INPUT #1, z0$
      DO UNTIL EOF(1)
        LINE INPUT #1, z0$
        z$ = ""
        IF LEN(z0$) > 11 THEN z$ = MID$(z0$, 10, LEN(z0$) - 11)
        FOR i = 1 TO LEN(z$) STEP 2
          nl% = dec(MID$(z$, i, 2))
          pt% = pt% + 1
          eew(pt% - 1) = nl%
          PRINT "    Lese EEPROM von Datentrger... ";
          PRINT USING " ######"; pt%; nl%
        NEXT i
      LOOP
      ewm = pt% - 1
    CLOSE
    IF ewm > erm THEN
      msg1 = "Eingelesene Datei ist"
      msg2 = "zu gro fr den Chip"
      msg3 = "Erlaubt sind:" + STR$(erm) + " Bytes"
      msg4 = "Tatschlich :" + STR$(ewm) + " Bytes"
      msgbox
    ELSE
      FOR j = pt% TO erm
        eew(j) = 255
      NEXT j
    END IF
    gesperrt(6) = 0: gesperrt(7) = 0: mp = 7
    'compeeprom
  END IF
END SUB

SUB leertest
  leertst = 1
  rdFlash
  LOCATE 13, 10
  IF benutzt = 0 THEN
    PRINT "Der AVR-Flash-Speicher ist leer..."
  ELSE
    PRINT "Der AVR-Flash-Speicher enthlt"; benutzt; " beschriebene Bytes..."
  END IF
  PRINT : PRINT : PRINT
  taste
END SUB

SUB liesdir
  CLS
  SHELL "dir *.hex >avr.dir"
  SHELL "dir *.eep >>avr.dir"
  CLOSE
  OPEN "avr.dir" FOR INPUT AS #1
    DO UNTIL EOF(1)
      LINE INPUT #1, t$
      IF LEN(t$) > 40 THEN
        IF LCASE$(MID$(t$, 10, 3)) = typ(mp) THEN
          dir(i) = t$
          i = i + 1
        END IF
      END IF
    LOOP
  CLOSE
  KILL "avr.dir"
  maxdir = i - 1
END SUB

SUB LiesSignatur
  IF angemeldet = 0 THEN startavr
  bv = 0: ff = 0
  aus(0) = &H30: aus(1) = 0: aus(2) = 0: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 1; 1;
'  LOCATE 24, 1
'  PRINT "lese Chipcode 1";
  schreib
  sig1 = ein(3)
  aus(0) = &H30: aus(1) = 0: aus(2) = 1: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 2; 2;
'  LOCATE 24, 1
'  PRINT "lese Chipcode 2";
  schreib
  sig2 = ein(3)
  aus(0) = &H30: aus(1) = 0: aus(2) = 2: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 3; 3;
'  LOCATE 24, 1
'  PRINT "lese Chipcode 3";
  schreib
  sig3 = ein(3)
  avrtyp

  aus(0) = &H38: aus(1) = 0: aus(2) = 0: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Kalibrationsbyte 0";
  schreib
  kalibyte(0) = ein(3)
  aus(0) = &H38: aus(1) = 0: aus(2) = 1: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Kalibrationsbyte 1";
  schreib
  kalibyte(1) = ein(3)
  aus(0) = &H38: aus(1) = 0: aus(2) = 2: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Kalibrationsbyte 2";
  schreib
  kalibyte(2) = ein(3)
  aus(0) = &H38: aus(1) = 0: aus(2) = 3: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Kalibrationsbyte 3";
  schreib
  kalibyte(3) = ein(3)

  aus(0) = &H50: aus(1) = 0: aus(2) = 0: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Fuse-Bits Low";
  schreib
  fusel = ein(3)
  fusel1 = ein(3)
  aus(0) = &H58: aus(1) = 8: aus(2) = 0: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Fuse-Bits High";
  schreib
  fuseh = ein(3)
  fuseh1 = ein(3)
  aus(0) = &HA8: aus(1) = 0: aus(2) = 0: aus(3) = 0
'  LOCATE 23, 1
'  PRINT USING " #####"; 4; 4;
'  LOCATE 24, 1
'  PRINT "lese Lock-Bits";
  schreib
  lockb = ein(3)
  lockb1 = ein(3)
  CLOSE
  OPEN "isp" + RIGHT$("00" + HEX$(atkz), 2) + ".cfg" FOR RANDOM AS #1 LEN = 2
    IF LOF(1) < 512 THEN
      n% = 0
      FOR i = 1 TO 256
        PUT #1, i, n%
      NEXT i
    END IF
    GET #1, 1 + kalibyte(0), delanz
  CLOSE
'  PRINT "            Device-Code: "; USING " ### "; sig1; sig2; sig3; kalibyte(0); kalibyte(1); kalibyte(2); kalibyte(3)
'  PRINT
  brenncheck
END SUB

SUB loesch
  IF angemeldet = 0 THEN startavr
  aus(0) = &HAC: aus(1) = &H80: aus(2) = 0: aus(3) = 0
  schreib
  zt = TIMER
  brenncheck
  warte 50, 0
  startavr
  LiesSignatur
  IF ff > 0 THEN EXIT SUB
  kalitext = "                    "
  CLOSE #1
  OPEN "isp" + RIGHT$("00" + HEX$(atkz), 2) + ".cfg" FOR RANDOM AS #1 LEN = 2
    GET #1, 1 + kalibyte(0), delanz
    delanz = delanz + 1
    PUT #1, 1 + kalibyte(0), delanz
  CLOSE
  kal = 0
  kaltyp = 0
  SELECT CASE kalib \ 10
    CASE 1
      kal = 1: kaltyp = 0
    CASE 3
      kal = 0: kaltyp = (fusel - 1) AND 3
  END SELECT
  IF kal + kaltyp THEN
    IF wrm < rdm THEN
      i = rdm
      aus(0) = &H40
      aus(1) = INT(i / 256) AND &HFF
      aus(2) = i AND &HFF
      aus(3) = kalibyte(kaltyp) AND &HFF
      schreib
      warte 12, 1
      brenncheck
      aus(0) = &H48
      aus(1) = INT(i / 256) AND &HFF
      aus(2) = i AND &HFF
      aus(3) = kalibyte(kaltyp) AND &HFF
      schreib
      zt = TIMER
      brenncheck
      CLS
      kalitext = "Kal.-Byte " + hx(kalibyte(kaltyp)) + " in Adr. " + hx4$((i))
      LOCATE 12, 15
      PRINT "Kalibrationsbyte "; hx(kalibyte(kaltyp)); " in Adresse "; hx4$((i)); " geschrieben..."
      warte 1000, 1
      SELECT CASE atkz      'AVRs mit Page-Programming
        CASE 41, 42, 102, 103, 104, 130, 131, 132, 133, 162, 194, 226
          aus(0) = &H4C
          schreib
          warte 1000, 1
      END SELECT
    END IF
  ELSE
    kalitext = "                      "
  END IF
  IF gesperrt(5) = 0 THEN mp = 5
END SUB

SUB menue
  STATIC k0 AS STRING, ri AS INTEGER
  DIM mt(18) AS STRING, mh(18) AS STRING
  DIM k AS STRING, meld(1) AS STRING
  abbr = 0
  meld(0) = "AVR-Chip deaktiviert ": meld(1) = "AVR-Chip aktiviert   "
  typ(9) = "hex": typ(10) = "eep": typ(11) = "hex": typ(12) = "eep"
  mt(0) = "AVR-Progr. aktivieren     "
  mh(0) = "Herstellen der ISP-Kommunikation mit dem AVR..."
  mt(1) = "AVR-Progr. deaktivieren   "
  mh(1) = "Beenden der ISP-Kommunikation mit dem AVR..."
  mt(2) = "Leertest                  "
  mh(2) = "Der FLASH des AVR wird darauf berprft, ob er leer ist..."
  mt(3) = "AVR-Chip lschen          "
  mh(3) = "FLASH und EEPROM werden gelscht, Oszillator wird ggf kalibriert..."
  mt(4) = "Programm-Flash lesen      "
  mh(4) = "Der FLASH des AVR wird eingelesen..."
  mt(5) = "Programm-Flash schreiben  "
  mh(5) = "Selektierte HEX-Datei in AVR-FLASH schreiben..."
  mt(6) = "Daten-EEPROM lesen        "
  mh(6) = "Der EEPROM des AVR wird eingelesen..."
  mt(7) = "Daten-EEPROM schreiben    "
  mh(7) = "Selektierte EEP-Datei in AVR-EEPROM schreiben..."
  mt(8) = "Inhalt des AVR bernehmen "
  mh(8) = "Der vom AVR gelesene Inhalt wird zum Schreiben bernommen..."
  mt(9) = "Flash-Datei von HDD laden "
  mh(9) = "FLASH-Datei (*.hex) im Intel-HEX-Format von Festplatte einlesen..."
  mt(10) = "EEPROM-Datei von HDD laden"
  mh(10) = "EEPROM-Datei (*.eep) im Intel-HEX-Format von Festplatte einlesen..."
  mt(11) = "FLASH zeigen/vergleichen  "
  mh(11) = "Anzeigen der geschriebenen und zurckgelesenen FLASH-Inhalte..."
  mt(12) = "EEPROM zeigen/vergleichen "
  mh(12) = "Anzeigen der geschriebenen und zurckgelesenen EEPROM-Inhalte..."
  mt(13) = "Lock/Fuse-Bits bearbeiten "
  mh(13) = "Anzeige und nderung/Speicherung der Lockbits und Fusebits des AVR..."
  mt(14) = "Strom ausschalten         "
  mh(14) = "Stromversorgung des AVR ausschalten..."
  mt(15) = "Strom einschalten         "
  mh(15) = "Stromversorgung des AVR einschalten..."
  mt(16) = "Info...                   "
  mh(16) = "Programminformation und Anschlussbelegung des ISP-Adapters..."
  mt(17) = "Neuer Chip (Stat. lschen)"
  mh(17) = "Statistikdaten (Anzahl Lschvorgnge) lschen..."
  mt(18) = "Programm beenden          "
  mh(18) = "Das Programm wird beendet..."
  mpa = 18
  x = 3
  CLS
  COLOR 15, 0
  PRINT "    ISP-Programmierung von AVR-Mikrocontrollern        (c) ...HanneS..."
  PRINT "Ŀ";
  FOR i = 1 TO 21
    PRINT "                                                                             ";
  NEXT i
  PRINT "";
  DO
    i = (80 - LEN(mh(mp))) / 2
    LOCATE 25, 1: PRINT "                                                                                ";
    LOCATE 25, i: COLOR 12, 0
    PRINT mh(mp);
    FOR i = 0 TO mpa
      c = 7
      IF gesperrt(i) <> 0 THEN c = 8
      LOCATE 3 + i, 56 - x
      COLOR c, 0
      IF i = mp THEN COLOR 0, c
      PRINT mt(i);
    NEXT i
    COLOR 9, 0
    LOCATE 3, x
    IF sig1 <> 0 THEN
      PRINT avrt; "     Code: "; hx$(sig1); " "; hx$(sig2); " "; hx$(sig3);
      LOCATE 16, x
      PRINT "FuH:"; bn$(fuseh); " FuL:"; bn$(fusel); " Lock:"; bn$(lockb);
    END IF
    LOCATE 4, x
    PRINT meld(angemeldet);
    IF angemeldet * kalib THEN
      PRINT USING "   Calmode #.# "; kalib / 10;
      IF kalib \ 10 = 3 THEN
        SELECT CASE fusel AND 15
          CASE 0
            PRINT " ext. Takt";
          CASE 1
            PRINT " int.1 MHz";
          CASE 2
            PRINT " int.2 MHz";
          CASE 3
            PRINT " int.4 MHz";
          CASE 4
            PRINT " int.8 MHz";
          CASE 5 TO 8
            PRINT " ext. RC  ";
          CASE 9 TO 15
            PRINT " ext.Quarz";
        END SELECT
      END IF
      LOCATE 5, x
      PRINT "Kalibrations-Bytes: "; hx$(kalibyte(0)); " "; hx$(kalibyte(1)); " "; hx$(kalibyte(2)); " "; hx$(kalibyte(3));
    END IF
    LOCATE 6, x
    PRINT kalitext
    LOCATE 7, x
    PRINT USING "Flash  Worte (max): ###### ("; rdm + 1; : PRINT hx4$(rdm + 1); ")";
    LOCATE 8, x
    PRINT USING "Flash  Worte (ist): ###### ("; wrm + 1; : PRINT hx4$(wrm + 1); ")";
    LOCATE 9, x
    PRINT USING "EEPROM Bytes (max): ###### ("; erm + 1; : PRINT hx4$(erm + 1); ")";
    LOCATE 10, x
    PRINT USING "EEPROM Bytes (ist): ###### ("; ewm + 1; : PRINT hx4$(ewm + 1); ")";
   
    LOCATE 12, x
    PRINT "Flash-Datei : "; danaf;
    LOCATE 13, x
    PRINT "EEPROM-Datei: "; danae;
   
    'LOCATE 17, x
    'PRINT "AVR-Typ : "; avrt;

    IF angemeldet THEN
      LOCATE 20, x
      IF kalib THEN
        PRINT avrt; "Nr"; kalibyte(0); "wurde"; delanz; "mal gelscht";
      ELSE
        PRINT avrt; " wurde"; delanz; "mal gelscht";
      END IF
    END IF
    DO
      k = INKEY$
    LOOP WHILE k = k0
    k0 = k
    SELECT CASE k
      CASE CHR$(13)
        EXIT DO
      CASE CHR$(27)
        ende
      CASE n$ + "H"
        ri = -1
      CASE n$ + "P"
        ri = 1
    END SELECT
    DO
      IF ri = 0 THEN EXIT DO
      mp = mp + ri
      IF mp < 0 THEN mp = mpa
      IF mp > mpa THEN mp = 0
    LOOP UNTIL gesperrt(mp) = 0
    ri = 0
  LOOP
  CLS
  COLOR 7, 0
  SELECT CASE mp
    CASE 0
      LiesSignatur
    CASE 1
      stopavr
    CASE 2
      leertest
    CASE 3
      loesch
    CASE 4
      leertst = 0
      rdFlash
    CASE 5
      wrFlash
    CASE 6
      rdEeprom
    CASE 7
      wrEeprom
    CASE 8
      kopie
    CASE 9, 10
      lade
    CASE 11
      compflash
    CASE 12
      compeeprom
    CASE 13
      wrlock
    CASE 14
      send = 255 - pwr
      OUT p, send
    CASE 15
      send = 255
      OUT p, send
    CASE 16
      info
    CASE 17
      delanz = 0
      CLOSE #1
      OPEN "isp" + RIGHT$("00" + HEX$(atkz), 2) + ".cfg" FOR RANDOM AS #1 LEN = 2
        IF LOF(1) < 512 THEN
          n% = 0
          FOR i = 1 TO 256
            PUT #1, i, n%
          NEXT i
        END IF
        PUT #1, 1 + kalibyte(0), delanz
      CLOSE
    CASE 18
      ende
  END SELECT
  END SUB

SUB msgbox
  COLOR 7, 1
  LOCATE 10, 13
  PRINT " Ŀ "
  FOR i = 11 TO 14
    LOCATE i, 13
  PRINT "                                                    "
  NEXT i
  LOCATE 15, 13
  PRINT "  "
  LOCATE 11, 16
  PRINT LEFT$(msg1, 48)
  LOCATE 12, 16
  PRINT LEFT$(msg2, 48)
  LOCATE 13, 16
  PRINT LEFT$(msg3, 48)
  LOCATE 14, 16
  PRINT LEFT$(msg4, 48)
  LOCATE 16, 20
  COLOR 7, 0
  DO
    k$ = INKEY$
  LOOP WHILE k$ = ""
  ta$ = k$
  CLS
  msg1 = ""
  msg2 = ""
  msg3 = ""
  msg4 = ""
END SUB

SUB rdEeprom
  IF angemeldet = 0 THEN startavr
  bv = 0: ff = 0
  FOR i = 0 TO erm
    aus(0) = &HA0
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = 0
'    LOCATE 23, 1
'    PRINT USING " #####"; i; erm;
    LOCATE 4, 30
    PRINT USING "lese EEPROM ###.##%"; i / erm * 100
    schreib
    eer(i) = ein(3)
    brenncheck
    IF INKEY$ = CHR$(27) THEN taste
    IF abbr <> 0 THEN EXIT SUB
    IF i = ewm AND ewm > 0 THEN
      msg1 = "Programmende erreicht..."
      msg2 = "Rest auch noch einlesen?"
      msg3 = "Enter-Taste = ja,"
      msg4 = "jede andere Taste = nein..."
      msgbox
      IF ta$ <> CHR$(13) THEN EXIT FOR
    END IF
  NEXT i
  gesperrt(12) = 0
  compeeprom
  stopavr
END SUB

SUB rdFlash
  DIM rl AS INTEGER, rh AS INTEGER
  startavr
  bv = 0: ff = 0: benutzt = 0
  CLS
  CLOSE
  OPEN "rfl.tmp" FOR RANDOM AS #3 LEN = 2
  OPEN "rfh.tmp" FOR RANDOM AS #4 LEN = 2
  FOR i = 0 TO rdm
    aus(0) = &H20
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = 0
    schreib
    brenncheck
    rl = ein(3)
    aus(0) = &H28
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = 0
    schreib
    LOCATE 4, 25: PRINT USING "lese Flash ###.##% "; i / rdm * 100;
    IF i <= wrm THEN PRINT USING "/ ###.##% "; i / wrm * 100;
    rh = ein(3)
    brenncheck
    PUT #3, i + 1, rl
    PUT #4, i + 1, rh
    IF rl <> 255 THEN benutzt = benutzt + 1
    IF rh <> 255 THEN benutzt = benutzt + 1
    IF INKEY$ = CHR$(27) THEN taste
    IF abbr <> 0 THEN EXIT SUB
    IF i = wrm AND wrm > 0 THEN
      IF rdm > 2000 THEN
        IF leertst = 0 THEN
          msg1 = "Programmende erreicht..."
          msg2 = "Rest auch noch einlesen?"
          msg3 = "Enter-Taste = ja,"
          msg4 = "jede andere Taste = nein..."
          msgbox
          CLS
          IF ta$ <> CHR$(13) THEN EXIT FOR
        END IF
      END IF
      IF leertst = 2 THEN EXIT FOR
    END IF
  NEXT i
  CLOSE
  gesperrt(11) = 0
  IF leertst = 0 THEN compflash
END SUB

SUB saveeeprom
  msg1 = "Diese Funktion ist noch nicht implementiert................"
  msgbox
END SUB

SUB saveflash
  msg1 = "Diese Funktion ist noch nicht implementiert................"
  msgbox
END SUB

SUB schreib
  'schreibt "aus" in den AVR, liest dabei "ein" aus dem AVR
  DIM a(31) AS INTEGER, e(31) AS INTEGER                'Bitfolge
  zl = CSRLIN
  FOR i = 0 TO 7
    a(i) = (2 ^ i AND aus(3)) / 2 ^ i
    a(i + 8) = (2 ^ i AND aus(2)) / 2 ^ i
    a(i + 16) = (2 ^ i AND aus(1)) / 2 ^ i
    a(i + 24) = (2 ^ i AND aus(0)) / 2 ^ i
  NEXT i
  FOR i = 31 TO 0 STEP -1
    j = 31 - i
    send = send AND (255 - mosi)
    send = send OR (a(i) * mosi)
    OUT p, send
'    warte 1, 1
    send = send OR sck
    OUT p, send
'    warte 1, 1
    e(i) = (INP(p + 1) AND 64) / 64
    send = send AND (255 - sck)
    OUT p, send

'    zl = 22
'    LOCATE zl - 1, 18
'    PRINT "TX:";
'    LOCATE zl - 1, 32 + j
'    PRINT LTRIM$(STR$(a(i)));
'    LOCATE zl, 18
'    PRINT "RX:";
'    LOCATE zl, 24 + j
'    PRINT LTRIM$(STR$(e(i)));
 
  NEXT i
  ein(0) = 0: ein(1) = 0: ein(2) = 0: ein(3) = 0
  FOR i = 0 TO 7
    ein(3) = ein(3) OR 2 ^ i * e(i)
    ein(2) = ein(2) OR 2 ^ i * e(i + 8)
    ein(1) = ein(1) OR 2 ^ i * e(i + 16)
    ein(0) = ein(0) OR 2 ^ i * e(i + 24)
  NEXT i
  IF ein(1) <> aus(0) THEN ff = ff + 1
  bv = bv + 1

'  PRINT "        "; USING " #####"; bv; ff;
'  LOCATE 25, 1
'  PRINT
'  PRINT

'  taste
END SUB

SUB startavr
'  LOCATE 12, 25
'  PRINT "Aktiviere Programmiermodus..."
  send = 255
  OUT p, send
  warte 100, 1
  send = 0
  OUT p, send
  i = TIMER
  warte 100, 1
  send = pwr
  OUT p, send
  warte 100, 1
  aus(0) = &HAC: aus(1) = &H53: aus(2) = 0: aus(3) = 0
  schreib
  warte 100, 1
  bv = 0: ff = 0
  schreib
  brenncheck
  IF ff < bv THEN angemeldet = 1
  LiesSignatur
END SUB

SUB stopavr
  send = 255
  OUT p, send
  send = 255 - pwr
  OUT p, send
'  warte 100, 1
'  send = 255
'  OUT p, send
  angemeldet = 0
  sig1 = 0
END SUB

SUB taste
  PRINT "      ...weiter mit Tastendruck...";
  DO
    k$ = INKEY$
  LOOP WHILE k$ = ""
  IF k$ = CHR$(27) THEN
    COLOR 7, 4
    LOCATE 10, 23
    PRINT " Ŀ "
    FOR i = 11 TO 14
      LOCATE i, 23
    PRINT "                                "
    NEXT i
    LOCATE 15, 23
    PRINT "  "
    LOCATE 11, 26
    PRINT "Programm beenden???"
    LOCATE 12, 26
    PRINT "Enter-Taste = Ende,"
    LOCATE 13, 26
    PRINT "Esc-Taste = Abbruch,"
    LOCATE 14, 26
    PRINT "jede andere Taste = weiter"
    LOCATE 16, 20
    COLOR 7, 0
    DO
      k$ = INKEY$
    LOOP WHILE k$ = ""
    IF k$ = CHR$(13) THEN ende
    IF k$ = CHR$(27) THEN abbr = 1
    CLS
  END IF
END SUB

SUB warte (n AS INTEGER, m AS INTEGER)
  IF m <> 0 THEN zt = TIMER
  DO UNTIL ABS(TIMER - zt) > (n / 1000)
    IF INKEY$ = CHR$(27) THEN EXIT DO
  LOOP
END SUB

SUB wrEeprom
'EEPROM schreiben
  IF angemeldet = 0 THEN startavr
  bv = 0: ff = 0
  IF ewm = 0 THEN EXIT SUB
  IF ewm > erm THEN ewm = erm
  FOR i = 0 TO ewm
    aus(0) = &HC0
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = eew(i) AND &HFF
    LOCATE 4, 30
    PRINT USING "brenne EEPROM ###.##"; i / ewm * 100
'    LOCATE 24, 1
'    PRINT "brenne EEPROM...";
    schreib
    warte 8, 1
    brenncheck
    aus(0) = &HA0
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = 0
'    LOCATE 23, 1
'    PRINT USING " #####"; i; erm;
'    LOCATE 24, 1
'    PRINT "lese EEPROM...";
    schreib
    eer(i) = ein(3)
    brenncheck
    IF INKEY$ = CHR$(27) THEN taste
    IF abbr <> 0 THEN EXIT SUB
  NEXT i
  gesperrt(6) = 0: gesperrt(12) = 0
  compeeprom
END SUB

SUB wrFlash
'Flash schreiben
  DIM wl AS INTEGER, wh AS INTEGER, l AS LONG
  IF angemeldet = 0 THEN startavr
  IF angemeldet = 0 THEN EXIT SUB
  leertst = 2
  rdFlash
  CLS
  IF benutzt <> 0 THEN
    CLS
    LOCATE 11, 16
    PRINT "Brennen verweigert, AVR ist nicht leer..."
    PRINT : PRINT : PRINT
    taste
    mp = 3
    EXIT SUB
  END IF
  bv = 0: ff = 0
  IF wrm = 0 THEN EXIT SUB
  IF wrm > rdm THEN wrm = rdm
    IF kopierflag = 0 THEN
      CLOSE
      OPEN "fl.tmp" FOR RANDOM AS #2 LEN = 2
      OPEN "fh.tmp" FOR RANDOM AS #3 LEN = 2
      CLOSE
      KILL "fl.tmp"
      KILL "fh.tmp"
      OPEN danaf FOR INPUT AS #1
      OPEN "fl.tmp" FOR RANDOM AS #2 LEN = 2
      OPEN "fh.tmp" FOR RANDOM AS #3 LEN = 2
        pt% = 0
        LINE INPUT #1, z0$
        DO UNTIL EOF(1)
          LINE INPUT #1, z0$
          z$ = ""
          IF LEN(z0$) > 11 THEN z$ = MID$(z0$, 10, LEN(z0$) - 11)
          FOR i = 1 TO LEN(z$) STEP 4
            nl% = dec(MID$(z$, i, 2))
            nh% = dec(MID$(z$, i + 2, 2))
            pt% = pt% + 1
            PUT #2, pt%, nl%
            PUT #3, pt%, nh%
            PRINT "    Konvertiere HEX-Datei auf Datentrger... ";
            PRINT USING " ######"; pt%; nl%; nh%
          NEXT i
        LOOP
      CLOSE
      wrm = pt% - 1
    END IF
  CLS
  brennbeginn = TIMER
  CLOSE
  OPEN "fl.tmp" FOR RANDOM AS #1 LEN = 2
  OPEN "fh.tmp" FOR RANDOM AS #2 LEN = 2
  FOR i = 0 TO wrm
    GET #1, i + 1, wl
    GET #2, i + 1, wh
    aus(0) = &H40
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = wl AND &HFF
    schreib
    SELECT CASE atkz
      CASE 41, 42, 102, 103, 104, 130, 131, 132, 133, 162, 194, 226
      CASE ELSE         'nur AVRs ohne Page-Programming
        warte 12, 1
    END SELECT
    brenncheck
    aus(0) = &H48
    aus(1) = INT(i / 256) AND &HFF
    aus(2) = i AND &HFF
    aus(3) = wh AND &HFF
    schreib
    zt = TIMER
    brenncheck
    LOCATE 5, 30
    PRINT USING "brenne Flash ###.##%"; i / wrm * 100
    SELECT CASE atkz
      CASE 41, 42                       'T26,T2313
        IF (i AND 15) = 15 THEN
          aus(0) = &H4C
          schreib
          warte 120, 1
       
        END IF
      CASE 102, 103, 104                'M8515,M8,M8535
        IF (i AND 31) = 31 THEN
          aus(0) = &H4C
          schreib
          warte 80, 1
        END IF
      CASE 130, 131, 132, 162           'M16,M162,M163,M32
        IF (i AND 63) = 63 THEN
          aus(0) = &H4C
          schreib
          warte 80, 1
        END IF
      CASE 194, 226                     'M64,M128
        IF (i AND 127) = 127 THEN
          aus(0) = &H4C
          schreib
          warte 80, 1
        END IF
      CASE ELSE
        warte 12, 0
    END SELECT
    IF INKEY$ = CHR$(27) THEN taste
    IF abbr <> 0 THEN
      CLOSE
      EXIT SUB
    END IF
  NEXT i
  SELECT CASE atkz      'AVRs mit Page-Programming
    CASE 41, 42, 102, 103, 104, 130, 131, 132, 133, 162, 194, 226
      aus(0) = &H4C
      schreib
      warte 100, 1
  END SELECT
  CLOSE
  gesperrt(11) = 0
  brenndauer = TIMER - brennbeginn
  leertst = 2
  rdFlash
  compflash
  mp = 1
  IF ugl <> 0 THEN mp = 3
END SUB

SUB wrlock
  DIM t(23) AS STRING, kal3(15) AS STRING
  DIM k AS STRING, kk(1) AS STRING
  STATIC mpf AS INTEGER, k0 AS STRING
  IF angemeldet = 0 THEN startavr
  kk(0) = "(set) ": kk(1) = "(clr) "
  kal3(0) = "Externer Takt               "
  kal3(1) = "Intern 1 MHz                "
  kal3(2) = "Intern 2 MHz                "
  kal3(3) = "Intern 4 MHz                "
  kal3(4) = "Intern 8 MHz                "
  kal3(5) = "Extern RC < 0,9 MHz         "
  kal3(6) = "Extern RC 0,9 - 3,0 MHz     "
  kal3(7) = "Extern RC 3,0 - 8,0 MHz     "
  kal3(8) = "Extern RC 8,0 - 12 MHz      "
  kal3(9) = "Externer langsamer Quarz    "
  kal3(10) = "Externer Quarz 0,4 - 0,9 MHZ"
  kal3(11) = "Externer Quarz 0,4 - 0,9 MHZ"
  kal3(12) = "Externer Quarz 0,9 - 3,0 MHZ"
  kal3(13) = "Externer Quarz 0,9 - 3,0 MHZ"
  kal3(14) = "Externer Quarz 3,0 - 8,0 MHZ"
  kal3(15) = "Externer Quarz 3,0 - 8,0 MHZ"

  SELECT CASE atkz
    CASE 5, 6   'Tiny12/15
      t(1) = "1 Lock 1"
      t(2) = "1 Lock 2"
      t(8 + 4) = "1 Reset-Disable"
      t(8 + 5) = "1 SPI-Enabled"
      t(8 + 6) = "1 BOD-Enabled"
      t(8 + 7) = "1 BOD-Level"

    CASE 41, 102, 103, 104, 131, 162       'T26,M8515,M8,M8535,M16,M32
      t(0) = "1 Lock 1"
      t(1) = "1 Lock 2"
      t(2) = "1 BootLock 01"
      t(3) = "1 BootLock 02"
      t(4) = "1 BootLock 11"
      t(5) = "1 BootLock 12"
      t(6) = "1"
      t(7) = "1"
      t(8) = "1 Clock-Select 0"
      t(9) = "0 Clock-Select 1"
      t(10) = "0 Clock-Select 2"
      t(11) = "0 Clock-Select 3"
      t(12) = "0 SUT0 (Start-Up-Time)"
      t(13) = "1 SUT1 (Start-Up-Time)"
      t(14) = "1 BOD-Enabled"
      t(15) = "1 BOD-Level"
      t(16) = "1 Boot-Reset"
      t(17) = "0 Boot-Gre 0"
      t(18) = "0 Boot-Gre 1"
      t(19) = "1 EESAVE"
      t(20) = "1 CKOPT (Oszillator-Option)"
      t(21) = "0"
      t(22) = "1 WDTON (Wachhund)"
      t(23) = "1 On Chip Debug Enable"
      IF atkz = 41 THEN         'T26
        t(2) = "1": t(3) = "1": t(4) = "1": t(5) = "1"
        t(16) = t(14)
        t(17) = t(15)
        t(14) = t(20)
        t(15) = "1 PLL-Clock"
        t(18) = t(19)
        t(19) = "0"
        t(20) = "1"
        t(21) = "1": t(22) = "1": t(23) = "1"
      ELSEIF atkz = 102 THEN    'M8515
        t(23) = "1 S8515-kompatibel"
      ELSEIF atkz = 104 THEN    'M8535
        t(23) = "1 S8535-kompatibel"
      ELSEIF atkz = 103 THEN    'M8
        t(23) = "1"
      ELSEIF atkz = 131 THEN    'M16
        t(22) = "0 JTAG-Enable"
      ELSEIF atkz = 162 THEN    'M32
        t(22) = "0 JTAG-Enable"
      END IF


    CASE ELSE
      msg1 = avrt
      msg3 = "Dieser AVR-Typ wird derzeit"
      msg4 = "noch nicht untersttzt..."
      msgbox
      EXIT SUB
  END SELECT
  CLS

  DO
    FOR i = 0 TO 7
     
      LOCATE 1 + i, 1
      j = (lockb AND 2 ^ i) / (2 ^ i)
      COLOR 7, 0: IF i = mpf THEN COLOR 0, 7
      PRINT "Lock  "; i; ": ";
      COLOR 14 - j * 8, 0
      PRINT j; kk(j);
      COLOR 7, 0
      PRINT t(i);
     
      LOCATE 9 + i, 1
      j = (fusel AND 2 ^ i) / (2 ^ i)
      COLOR 10, 0: IF i + 8 = mpf THEN COLOR 0, 10
      PRINT "Fuse L"; i; ": ";
      COLOR 14 - j * 8, 0
      PRINT j; kk(j);
      COLOR 7, 0
      PRINT t(i + 8);
    
      LOCATE 17 + i, 1
      j = (fuseh AND 2 ^ i) / (2 ^ i)
      COLOR 11, 0: IF i + 16 = mpf THEN COLOR 0, 11
      PRINT "Fuse H"; i; ": ";
      COLOR 14 - j * 8, 0
      PRINT j; kk(j);
      COLOR 7, 0
      PRINT t(i + 16);

    NEXT i
    LOCATE 25, 1
    COLOR 7, 0
    PRINT "Auswahl mit Cursor, ndern mit SPACE, Abbruch mit ESC, Brennen mit ENTER...";
    SELECT CASE kalib
      CASE 30 TO 39             'Kalibrationsversion 3.x
        i = fusel AND 15
        LOCATE 9, 50
        PRINT "Takt des "; avrt
        LOCATE 10, 50
        PRINT kal3(i);
    END SELECT
    DO
      k = INKEY$
    LOOP WHILE k = k0
    k0 = k
    i = mpf AND 7
    SELECT CASE k
      CASE " "
        SELECT CASE mpf
          CASE 0 TO 7
            lockb = lockb XOR (2 ^ i)
          CASE 8 TO 15
            fusel = fusel XOR (2 ^ i)
          CASE 16 TO 23
            fuseh = fuseh XOR (2 ^ i)
        END SELECT
      CASE CHR$(13)
        EXIT DO
      CASE CHR$(27)
        EXIT SUB
      CASE n$ + "H"
        mpfr = -1
      CASE n$ + "P"
        mpfr = 1
    END SELECT
    DO
      mpf = mpf + mpfr
      IF mpf < 0 THEN mpf = 23
      IF mpf > 23 THEN mpf = 0
    LOOP UNTIL LEN(t(mpf)) > 0
    mpfr = 0
  LOOP
  
  IF (lockb = lockb1) AND (fusel = fusel1) AND (fuseh = fuseh1) THEN
    CLS
    LOCATE 13, 20
    PRINT "Es wurden keine nderungen vorgenommen..."
    warte 3000, 1
    EXIT SUB
  END IF
  msg1 = "Soll die genderte Konfiguration wirklich"
  msg2 = "in den AVR bernommen werden?"
  msg4 = "Enter = ja, jede andere Taste = nein..."
  CLS
  msgbox
  IF ta$ = CHR$(13) THEN
    LOCATE 10, 20
    PRINT "Lockbits und Fusebits werden gebrannt...": PRINT
    SELECT CASE atkz
      CASE 41, 102, 103, 104, 131, 162       'T26,M8515,M8,M8535,M16,M32
        IF lockb <> lockb1 THEN
          PRINT , , "- Lock-Bits..."
          aus(0) = &HA8: aus(1) = &H0: aus(2) = &HFF: aus(3) = lockb
          schreib
          warte 25, 1
          brenncheck
        END IF
        IF fusel <> fusel1 THEN
          PRINT , , "- Fuse-Bits..."
          aus(0) = &HAC: aus(1) = &HA0: aus(2) = &HFF: aus(3) = fusel
          schreib
          warte 25, 1
          brenncheck
        END IF
        IF fuseh <> fuseh1 THEN
          PRINT , , "- Fuse-High-Bits..."
          aus(0) = &HAC: aus(1) = &HA8: aus(2) = &HFF: aus(3) = fuseh
          schreib
          warte 25, 1
          brenncheck
        END IF
      
      warte 5000, 1
    END SELECT
    stopavr
    startavr
  END IF
  
END SUB

